<?php include 'header.php'; ?>

    <!-- Page Hero -->
    <section class="page-hero">
        <div class="container">
            <h1>Contact Us</h1>
            <p class="lead">We'd love to hear from you. Get in touch with our team today.</p>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="content-section">
        <div class="container">
            <div class="row">
                <!-- Contact Form -->
                <div class="col-lg-8 mb-5 mb-lg-0">
                    <div class="card shadow-sm border-0">
                        <div class="card-body p-4">
                            <h3 class="mb-4">Send Us a Message</h3>
                            
                            <?php
                            // Display success message if form was submitted successfully
                            if (isset($_GET['success']) && $_GET['success'] == '1') {
                                echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <i class="fas fa-check-circle me-2"></i>Thank you! Your message has been sent successfully. We will get back to you soon.
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                      </div>';
                            }
                            
                            // Display error message if form submission failed
                            if (isset($_GET['error']) && $_GET['error'] == '1') {
                                echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                                        <i class="fas fa-exclamation-circle me-2"></i>There was an error sending your message. Please try again.
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                      </div>';
                            }
                            ?>
                            
                            <form action="contact-process.php" method="POST" id="contactForm">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="name" name="name" required>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                        <input type="email" class="form-control" id="email" name="email" required>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="phone" class="form-label">Phone Number</label>
                                    <input type="tel" class="form-control" id="phone" name="phone">
                                </div>
                                
                                <div class="mb-3">
                                    <label for="service" class="form-label">Service Type <span class="text-danger">*</span></label>
                                    <select class="form-select" id="service" name="service" required>
                                        <option value="">Select a service...</option>
                                        <option value="E-commerce & Digital Services">E-commerce & Digital Services</option>
                                        <option value="Retail, Trade & Distribution">Retail, Trade & Distribution</option>
                                        <option value="Logistics & Supply Chain">Logistics & Supply Chain</option>
                                        <option value="Construction & Technical Services">Construction & Technical Services</option>
                                        <option value="Human Resources & Consultancy">Human Resources & Consultancy</option>
                                        <option value="Corporate & Financial Solutions">Corporate & Financial Solutions</option>
                                        <option value="General Inquiry">General Inquiry</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="message" class="form-label">Message <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="message" name="message" rows="6" required></textarea>
                                </div>
                                
                                <div class="mb-3">
                                    <button type="submit" class="btn btn-submit">
                                        <i class="fas fa-paper-plane me-2"></i>Send Message
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-4">
                    <div class="card service-card p-4 h-100">
                        <div class="card-body">
                            <h3 class="mb-4">Get In Touch</h3>
                            
                            <div class="mb-4">
                                <div class="d-flex align-items-start mb-3">
                                    <div class="service-icon me-3" style="font-size: 1.5rem;">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </div>
                                    <div>
                                        <h5>Address</h5>
                                        <p class="text-muted mb-0">Nigeria<br>Lagos, Nigeria</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex align-items-start mb-3">
                                    <div class="service-icon me-3" style="font-size: 1.5rem;">
                                        <i class="fas fa-envelope"></i>
                                    </div>
                                    <div>
                                        <h5>Email</h5>
                                        <p class="text-muted mb-0">
                                            <a href="mailto:hello@sagestrategiesgroup.org" class="text-decoration-none">hello@sagestrategiesgroup.org</a>
                                        </p>
                                    </div>
                                </div>
                                
                                <div class="d-flex align-items-start mb-3">
                                    <div class="service-icon me-3" style="font-size: 1.5rem;">
                                        <i class="fas fa-phone"></i>
                                    </div>
                                    <div>
                                        <h5>Phone</h5>
                                        <p class="text-muted mb-0">+234 XXX XXX XXXX</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex align-items-start">
                                    <div class="service-icon me-3" style="font-size: 1.5rem;">
                                        <i class="fas fa-clock"></i>
                                    </div>
                                    <div>
                                        <h5>Business Hours</h5>
                                        <p class="text-muted mb-0">
                                            Monday - Friday: 8:00 AM - 6:00 PM<br>
                                            Saturday: 9:00 AM - 2:00 PM<br>
                                            Sunday: Closed
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            <hr>
                            
                            <h5 class="mb-3">Follow Us</h5>
                            <div class="d-flex gap-3">
                                <a href="#" class="btn btn-outline-primary btn-sm">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                                <a href="#" class="btn btn-outline-primary btn-sm">
                                    <i class="fab fa-twitter"></i>
                                </a>
                                <a href="#" class="btn btn-outline-primary btn-sm">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                                <a href="#" class="btn btn-outline-primary btn-sm">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Office Locations -->
    <section class="content-section bg-light">
        <div class="container">
            <h2 class="section-title">Our Office Locations</h2>
            <div class="row g-4 mt-3">
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body">
                            <div class="service-icon">
                                <i class="fas fa-building"></i>
                            </div>
                            <h5>Head Office</h5>
                            <p class="text-muted mb-2">Lagos, Nigeria</p>
                            <p class="text-muted small">Main administrative and operational headquarters</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body">
                            <div class="service-icon">
                                <i class="fas fa-warehouse"></i>
                            </div>
                            <h5>Logistics Center</h5>
                            <p class="text-muted mb-2">Abuja, Nigeria</p>
                            <p class="text-muted small">Central distribution and warehousing facility</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body">
                            <div class="service-icon">
                                <i class="fas fa-store"></i>
                            </div>
                            <h5>Retail Outlets</h5>
                            <p class="text-muted mb-2">Multiple Locations</p>
                            <p class="text-muted small">Retail stores and service centers nationwide</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Section -->
    <section class="content-section">
        <div class="container">
            <h2 class="section-title">Find Us on the Map</h2>
            <div class="row">
                <div class="col-12">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body p-0">
                            <div style="height: 400px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); display: flex; align-items: center; justify-content: center; border-radius: 10px;">
                                <div class="text-center">
                                    <i class="fas fa-map-marked-alt" style="font-size: 4rem; color: var(--navy-blue); margin-bottom: 1rem;"></i>
                                    <p class="text-muted">Interactive map coming soon</p>
                                    <p class="text-muted small">Lagos, Nigeria</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="content-section bg-light">
        <div class="container">
            <h2 class="section-title">Frequently Asked Questions</h2>
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="accordion" id="faqAccordion">
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="faq1">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1">
                                    How quickly will you respond to my inquiry?
                                </button>
                            </h2>
                            <div id="collapse1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    We typically respond to all inquiries within 24 hours during business days. For urgent matters, please call our direct line.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="faq2">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2">
                                    Do you provide services outside Nigeria?
                                </button>
                            </h2>
                            <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Yes, we provide services across West Africa and are expanding our reach. Contact us to discuss your specific location requirements.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="faq3">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3">
                                    Can I get a custom quote for my project?
                                </button>
                            </h2>
                            <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Absolutely! Fill out our contact form with your project details, and our team will provide a customized quote based on your specific needs.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="faq4">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4">
                                    What payment methods do you accept?
                                </button>
                            </h2>
                            <div id="collapse4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    We accept various payment methods including bank transfers, credit cards, and other secure payment options. Payment terms are discussed during project planning.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php include 'footer.php'; ?>

