<?php include 'header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <h1>Empowering Businesses through Innovative Strategies & Integrated Solutions</h1>
                    <p class="lead">Your trusted partner for comprehensive business solutions across E-commerce, Logistics, Construction, and Human Resources.</p>
                    <div class="d-flex gap-3 flex-wrap">
                        <a href="contact.php" class="btn btn-primary-custom">
                            <i class="fas fa-comments me-2"></i>Consult Us
                        </a>
                        <a href="about.php" class="btn btn-outline-light">
                            <i class="fas fa-info-circle me-2"></i>Learn More
                        </a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <img src="https://images.unsplash.com/photo-1521737604893-d14cc237f11d?w=800&h=600&fit=crop" alt="Business Strategy" class="img-fluid rounded shadow-lg">
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="stat-number">6+</div>
                        <p class="text-muted mb-0">Service Sectors</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="stat-number">500+</div>
                        <p class="text-muted mb-0">Clients Served</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="stat-number">50+</div>
                        <p class="text-muted mb-0">Expert Team</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="stat-number">10+</div>
                        <p class="text-muted mb-0">Years Experience</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Preview Section -->
    <section class="content-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?w=800&h=600&fit=crop" alt="About SAGE STRATEGIES" class="img-fluid">
                </div>
                <div class="col-lg-6">
                    <h2 class="section-title text-start">About SAGE STRATEGIES</h2>
                    <p class="lead text-muted">A multi-sector conglomerate dedicated to driving business excellence.</p>
                    <p>SAGE STRATEGIES is a dynamic, multi-sector conglomerate committed to empowering businesses across Nigeria and beyond. We provide integrated solutions that combine innovation, expertise, and strategic thinking to help our clients achieve sustainable growth and competitive advantage.</p>
                    <p>With a diverse portfolio spanning E-commerce, Logistics, Construction, and Human Resources, we offer end-to-end services that address every aspect of modern business operations. Our commitment to excellence and customer-centric approach has made us a trusted partner for businesses of all sizes.</p>
                    <a href="about.php" class="btn btn-submit mt-3">
                        <i class="fas fa-arrow-right me-2"></i>Read More About Us
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Preview Section -->
    <section class="services-section">
        <div class="container">
            <h2 class="section-title">Our Services</h2>
            <p class="text-center text-muted mb-5">Comprehensive solutions tailored to your business needs</p>
            
            <div class="row g-4">
                <!-- Service Card 1: E-Commerce & Digital Services -->
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-shopping-cart"></i>
                            </div>
                            <h5 class="card-title">E-Commerce & Digital Services</h5>
                            <p class="card-text text-muted">Transform your business with our cutting-edge e-commerce platforms and digital solutions. We provide robust online marketplaces, POS systems, and ICT services.</p>
                            <a href="services.php" class="btn btn-sm btn-outline-primary">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Service Card 2: Retail, Trade & Distribution -->
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-store"></i>
                            </div>
                            <h5 class="card-title">Retail, Trade & Distribution</h5>
                            <p class="card-text text-muted">From online and physical retail outlets to global import/export operations, we handle all aspects of trade and distribution seamlessly.</p>
                            <a href="services.php" class="btn btn-sm btn-outline-primary">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Service Card 3: Logistics & Supply Chain -->
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-truck"></i>
                            </div>
                            <h5 class="card-title">Logistics & Supply Chain</h5>
                            <p class="card-text text-muted">Streamline your operations with our comprehensive logistics services including transportation, warehousing, and equipment leasing.</p>
                            <a href="services.php" class="btn btn-sm btn-outline-primary">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Service Card 4: Construction & Technical Services -->
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-hard-hat"></i>
                            </div>
                            <h5 class="card-title">Construction & Technical Services</h5>
                            <p class="card-text text-muted">Build with confidence. Our construction services cover residential, commercial, and public infrastructure projects.</p>
                            <a href="services.php" class="btn btn-sm btn-outline-primary">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Service Card 5: Human Resources & Consultancy -->
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <h5 class="card-title">Human Resources & Consultancy</h5>
                            <p class="card-text text-muted">Unlock your workforce potential. We provide recruitment, training, and supply of skilled and unskilled labor.</p>
                            <a href="services.php" class="btn btn-sm btn-outline-primary">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Service Card 6: Corporate & Financial Solutions -->
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-briefcase"></i>
                            </div>
                            <h5 class="card-title">Corporate & Financial Solutions</h5>
                            <p class="card-text text-muted">Navigate corporate complexities with confidence. We provide strategic financial solutions and comprehensive corporate services.</p>
                            <a href="services.php" class="btn btn-sm btn-outline-primary">Learn More</a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="text-center mt-5">
                <a href="services.php" class="btn btn-submit">
                    <i class="fas fa-arrow-right me-2"></i>View All Services
                </a>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="content-section bg-light">
        <div class="container">
            <h2 class="section-title">Why Choose SAGE STRATEGIES?</h2>
            <div class="row g-4 mt-3">
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box text-center">
                        <div class="service-icon">
                            <i class="fas fa-award"></i>
                        </div>
                        <h5>Proven Excellence</h5>
                        <p class="text-muted">Years of experience delivering exceptional results across multiple industries.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box text-center">
                        <div class="service-icon">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h5>Expert Team</h5>
                        <p class="text-muted">Dedicated professionals with deep industry knowledge and expertise.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box text-center">
                        <div class="service-icon">
                            <i class="fas fa-rocket"></i>
                        </div>
                        <h5>Innovation Driven</h5>
                        <p class="text-muted">Cutting-edge solutions and technologies to keep you ahead of the competition.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box text-center">
                        <div class="service-icon">
                            <i class="fas fa-headset"></i>
                        </div>
                        <h5>24/7 Support</h5>
                        <p class="text-muted">Round-the-clock customer support to address your needs anytime.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-5" style="background: linear-gradient(135deg, var(--navy-blue) 0%, #003366 100%); color: white;">
        <div class="container text-center">
            <h2 class="mb-4">Ready to Transform Your Business?</h2>
            <p class="lead mb-4">Let's discuss how SAGE STRATEGIES can help you achieve your goals.</p>
            <a href="contact.php" class="btn btn-primary-custom">
                <i class="fas fa-paper-plane me-2"></i>Get Started Today
            </a>
        </div>
    </section>

<?php include 'footer.php'; ?>
